/*
 * Decompiled with CFR 0.152.
 */
package com.yollo.dmlreforged.core.configs;

import com.yollo.dmlreforged.core.configs.BalanceConfigs;
import com.yollo.dmlreforged.core.configs.ClientConfig;
import com.yollo.dmlreforged.core.configs.EnergyCostConfig;
import com.yollo.dmlreforged.core.configs.LivingExpConfig;
import com.yollo.dmlreforged.core.configs.MobConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class Config {
    public static void register() {
        Config.registerClientConfigs();
        Config.registerServerConfigs();
        Config.registerCommonConfigs();
    }

    private static void registerServerConfigs() {
        ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
        BalanceConfigs.registerServerConfig(SERVER_BUILDER);
        EnergyCostConfig.registerServerConfig(SERVER_BUILDER);
        LivingExpConfig.registerServerConfig(SERVER_BUILDER);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_BUILDER.build());
    }

    private static void registerCommonConfigs() {
        ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        MobConfig.registerCommonConfig(COMMON_BUILDER);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_BUILDER.build());
    }

    private static void registerClientConfigs() {
        ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        ClientConfig.registerClientConfig(CLIENT_BUILDER);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_BUILDER.build());
    }
}

